/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.api.items.builders;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Collection;
import net.impactdev.impactor.api.items.ImpactorItemStack;
import net.impactdev.impactor.api.items.properties.MetaFlag;
import net.impactdev.impactor.api.items.properties.enchantments.Enchantment;
import net.impactdev.impactor.api.utility.builders.Builder;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.kyori.adventure.text.Component;
import org.checkerframework.checker.index.qual.Positive;
import org.jetbrains.annotations.Contract;

public interface ImpactorItemStackBuilder<I extends ImpactorItemStack, B extends ImpactorItemStackBuilder<I, B>>
extends Builder<I> {
    @CanIgnoreReturnValue
    @Contract(value="_ -> this")
    public B quantity(int var1);

    @CanIgnoreReturnValue
    @Contract(value="_ -> this")
    public B title(Component var1);

    @CanIgnoreReturnValue
    @Contract(value="_ -> this")
    public B lore(Component ... var1);

    @CanIgnoreReturnValue
    @Contract(value="_ -> this")
    public B lore(Collection<Component> var1);

    @CanIgnoreReturnValue
    @Contract(value="_ -> this")
    public B enchantment(Enchantment var1);

    @CanIgnoreReturnValue
    @Contract(value="_,_ -> this")
    default public B enchantments(Enchantment primary, Enchantment ... enchantments) {
        this.enchantment(primary);
        for (Enchantment enchantment : enchantments) {
            this.enchantment(enchantment);
        }
        return (B)this;
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this")
    default public B enchantments(Collection<Enchantment> enchantments) {
        for (Enchantment enchantment : enchantments) {
            this.enchantment(enchantment);
        }
        return (B)this;
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this")
    public B durability(@Positive int var1);

    @CanIgnoreReturnValue
    @Contract(value="-> this")
    default public B unbreakable() {
        return this.unbreakable(true);
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this")
    public B unbreakable(boolean var1);

    @CanIgnoreReturnValue
    @Contract(value="_ -> this")
    public B hide(MetaFlag ... var1);

    @CanIgnoreReturnValue
    @Contract(value="_ -> this")
    public B hide(Collection<MetaFlag> var1);

    @CanIgnoreReturnValue
    @Contract(value="-> this")
    public B glow();

    @CanIgnoreReturnValue
    @Contract(value="_ -> this")
    public B customModelData(int var1);

    @CanIgnoreReturnValue
    @Contract(value="_ -> this")
    public B nbt(CompoundBinaryTag var1);
}

